/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import gui.action.AcceptAllFileFilter;
import gui.action.FileNameExtensionFilter;
import gui.editor.EditorPane;
import gui.environment.Universe;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class SaveGraphUtility {
    public static void saveGraph(Component apane, JComponent c, String description, String format) {
        if (apane instanceof EditorPane) {
            apane = ((EditorPane)apane).getAutomatonPane();
        }
        Image canvasimage = apane.createImage(apane.getWidth(), apane.getHeight());
        Graphics imgG = canvasimage.getGraphics();
        apane.paint(imgG);
        BufferedImage bimg = new BufferedImage(canvasimage.getWidth(null), canvasimage.getHeight(null), 1);
        Graphics2D g = bimg.createGraphics();
        g.drawImage(canvasimage, null, null);
        Universe.CHOOSER.resetChoosableFileFilters();
        Universe.CHOOSER.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter spec = new FileNameExtensionFilter(description, format.split(","));
        Universe.CHOOSER.addChoosableFileFilter(spec);
        Universe.CHOOSER.addChoosableFileFilter(new AcceptAllFileFilter());
        Universe.CHOOSER.setFileFilter(spec);
        int result = Universe.CHOOSER.showSaveDialog(c);
        while (result == 0) {
            int confirm;
            File file = Universe.CHOOSER.getSelectedFile();
            if (!new FileNameExtensionFilter(description, format.split(",")).accept(file)) {
                file = new File(String.valueOf(file.getAbsolutePath()) + "." + format.split(",")[0]);
            }
            if (file.exists() && (confirm = JOptionPane.showConfirmDialog(Universe.CHOOSER, "File exists. Shall I overwrite?", "FILE OVERWRITE ATTEMPTED", 0)) == 1) {
                result = Universe.CHOOSER.showSaveDialog(c);
                continue;
            }
            try {
                ImageIO.write((RenderedImage)bimg, format.split(",")[0], file);
                return;
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(c, "Save failed with error:\n" + ioe.getMessage(), "Save failed", 0);
                return;
            }
        }
    }
}

