/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import gui.action.RestrictedAction;
import gui.environment.Environment;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class PrintAction
extends RestrictedAction {
    private static final long serialVersionUID = 1L;
    private Environment environment;

    public PrintAction(Environment environment) {
        super("Print", null);
        this.environment = environment;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, MAIN_MENU_MASK));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent c = (JComponent)this.environment.getActive();
        PrintUtilities.printComponent(c);
    }

    public static interface Bounds {
        public Rectangle2D printerBounds();
    }

    private static class PrintUtilities
    implements Printable {
        private JComponent componentToBePrinted;

        public static void printComponent(JComponent c) {
            new PrintUtilities(c).print();
        }

        public PrintUtilities(JComponent componentToBePrinted) {
            this.componentToBePrinted = componentToBePrinted;
        }

        public void print() {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            if (printJob == null) {
                System.err.println("Error in Printing");
            } else {
                if (this.componentToBePrinted instanceof Bounds) {
                    Bounds b = (Bounds)((Object)this.componentToBePrinted);
                    Rectangle2D bounds = b.printerBounds();
                    Paper paper = new Paper();
                    paper.setSize(2.0 * bounds.getX() + bounds.getWidth(), 2.0 * bounds.getY() + bounds.getHeight());
                    paper.setImageableArea(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                    PageFormat pf = new PageFormat();
                    pf.setPaper(paper);
                    printJob.setPrintable(this, pf);
                } else {
                    printJob.setPrintable(this);
                }
                if (printJob.printDialog()) {
                    try {
                        printJob.print();
                    }
                    catch (PrinterException pe) {
                        System.err.println("Error printing: " + pe);
                    }
                }
            }
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
            if (pageIndex > 0) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            Rectangle clip = g2d.getClipBounds();
            Rectangle size = new Rectangle(this.componentToBePrinted.getSize());
            double wratio = ((RectangularShape)clip).getWidth() / ((RectangularShape)size).getWidth();
            double hratio = ((RectangularShape)clip).getWidth() / ((RectangularShape)size).getWidth();
            if (wratio < hratio) {
                g2d.scale(wratio, wratio);
            } else {
                g2d.scale(hratio, hratio);
            }
            this.componentToBePrinted.print(g2d);
            return 0;
        }
    }
}

