/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.NondeterminismDetector;
import automata.NondeterminismDetectorFactory;
import automata.State;
import gui.action.AutomatonAction;
import gui.editor.ArrowDisplayOnlyTool;
import gui.environment.Environment;
import gui.environment.tag.CriticalTag;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NondeterminismAction
extends AutomatonAction {
    private static final long serialVersionUID = 1L;
    private Automaton automaton;
    private Environment environment;

    public NondeterminismAction(Automaton automaton, Environment environment) {
        super("Highlight Nondeterminism", null);
        this.automaton = automaton;
        this.environment = environment;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SelectionDrawer drawer = new SelectionDrawer(this.automaton);
        NondeterminismDetector d = NondeterminismDetectorFactory.getDetector(this.automaton);
        State[] nd = d.getNondeterministicStates(this.automaton);
        int i = 0;
        while (i < nd.length) {
            drawer.addSelected(nd[i]);
            ++i;
        }
        AutomatonPane ap = new AutomatonPane(drawer);
        NondeterminismPane pane = new NondeterminismPane(ap);
        this.environment.add((Component)pane, "Nondeterminism", new CriticalTag(){});
        this.environment.setActive(pane);
    }

    public static boolean isApplicable(Object object) {
        return object instanceof Automaton;
    }

    private class NondeterminismPane
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public NondeterminismPane(AutomatonPane ap) {
            super(new BorderLayout());
            ap.addMouseListener(new ArrowDisplayOnlyTool(ap, ap.getDrawer()));
            this.add((Component)ap, "Center");
            this.add((Component)new JLabel("Nondeterministic states are highlighted."), "North");
        }
    }
}

