/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import grammar.Grammar;
import gui.action.SimulateAction;
import gui.environment.Environment;
import gui.environment.Universe;
import gui.sim.TraceWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class NoInteractionSimulateAction
extends SimulateAction {
    private static final long serialVersionUID = 1L;
    private Environment environment = null;
    protected static final int WARNING_STEP = 500;

    public NoInteractionSimulateAction(Grammar gram, Environment environment) {
        super(gram, environment);
        this.putValue("Name", "Fast Run...");
        this.putValue("AcceleratorKey", null);
        this.environment = environment;
    }

    public NoInteractionSimulateAction(Automaton automaton, Environment environment) {
        super(automaton, environment);
        this.putValue("Name", "Fast Run...");
        this.putValue("AcceleratorKey", null);
        this.environment = environment;
    }

    protected boolean reportConfiguration(Configuration configuration, Component component) {
        JScrollPane past = TraceWindow.getPastPane(configuration);
        past.setPreferredSize(new Dimension(300, 400));
        Object[] options = new String[]{"Keep looking", "I'm done"};
        int result = JOptionPane.showOptionDialog(component, past, "Accepting configuration found!", 0, 1, null, options, null);
        return result == 0;
    }

    protected boolean confirmContinue(int generated, Component component) {
        int result = JOptionPane.showConfirmDialog(component, String.valueOf(generated) + " configurations have been generated.  " + "Should we continue?");
        return result == 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handleInteraction(Automaton automaton, AutomatonSimulator simulator, Configuration[] configs, Object initialInput) {
        frame = Universe.frameForEnvironment(this.environment);
        numberGenerated = 0;
        warningGenerated = 500;
        numberAccepted = 0;
        while (configs.length > 0) {
            block7: {
                if ((numberGenerated += configs.length) < warningGenerated) break block7;
                if (this.confirmContinue(numberGenerated, frame)) ** GOTO lbl10
                return;
lbl-1000:
                // 1 sources

                {
                    warningGenerated *= 2;
lbl10:
                    // 2 sources

                    ** while (numberGenerated >= warningGenerated)
                }
            }
            next = new ArrayList<Configuration>();
            i = 0;
            while (i < configs.length) {
                if (configs[i].isAccept()) {
                    ++numberAccepted;
                    if (!this.reportConfiguration(configs[i], frame)) {
                        return;
                    }
                } else {
                    next.addAll(simulator.stepConfiguration(configs[i]));
                }
                ++i;
            }
            configs = next.toArray(new Configuration[0]);
        }
        if (numberAccepted == 0) {
            JOptionPane.showMessageDialog(frame, "The input was rejected.");
            return;
        }
        JOptionPane.showMessageDialog(frame, String.valueOf(numberAccepted) + " configuration" + (numberAccepted == 1 ? "" : "s") + " accepted, and\nother possibilities are exhausted.");
    }
}

