/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import grammar.CNFConverter;
import grammar.Grammar;
import grammar.Production;
import grammar.ProductionChecker;
import grammar.UnrestrictedGrammar;
import gui.action.GrammarAction;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class GrammarTypeTestAction
extends GrammarAction {
    private static final long serialVersionUID = 1L;
    private GrammarEnvironment environment;
    private EnvironmentFrame frame;

    public GrammarTypeTestAction(GrammarEnvironment environment) {
        super("Test for Grammar Type", null);
        this.environment = environment;
        this.frame = Universe.frameForEnvironment(environment);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Grammar g = this.environment.getGrammar(UnrestrictedGrammar.class);
        if (g == null) {
            return;
        }
        Production[] p = g.getProductions();
        boolean isRegular = this.checkforLinearity(p);
        if (!isRegular && !this.isContextFreeGrammar(p, g)) {
            this.checkForSpecialUnrestrictedGrammar(p);
        }
    }

    private void checkForSpecialUnrestrictedGrammar(Production[] p) {
        Production[] sp = new Production[]{new Production("S", "V(==)S"), new Production("S", "SV(==)"), new Production("S", "T")};
        boolean[] count = new boolean[3];
        int i = 0;
        while (i < p.length) {
            int j = 0;
            while (j < sp.length) {
                if (p[i].getLHS().equals(sp[j].getLHS()) && p[i].getRHS().equals(sp[j].getRHS())) {
                    count[i] = true;
                }
                ++j;
            }
            ++i;
        }
        int pp = 0;
        int i2 = 0;
        while (i2 < count.length) {
            if (count[i2]) {
                ++pp;
            }
            ++i2;
        }
        if (pp == count.length) {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is an Unrestricted Grammar (converted from TM)", "Grammar Type", 1);
        } else {
            int tt = 0;
            int i3 = 0;
            while (i3 < p.length) {
                if (p[i3].getLHS().length() <= p[i3].getRHS().length()) {
                    ++tt;
                }
                ++i3;
            }
            if (tt == p.length) {
                JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a Context-Sensitive Grammar (also Unrestricted Grammar)", "Grammar Type", 1);
            } else {
                JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is an Unrestricted Grammar", "Grammar Type", 1);
            }
        }
    }

    private boolean isContextFreeGrammar(Production[] p, Grammar g) {
        int count = 0;
        int i = 0;
        while (i < p.length) {
            if (ProductionChecker.isRestrictedOnLHS(p[i])) {
                ++count;
            }
            ++i;
        }
        if (count != p.length) {
            return false;
        }
        CNFConverter converter = null;
        converter = new CNFConverter(g);
        boolean chomsky = true;
        int i2 = 0;
        while (i2 < p.length) {
            chomsky &= converter.isChomsky(p[i2]);
            ++i2;
        }
        if (chomsky) {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a CNF Grammar (also Context-Free Grammar)", "Grammar Type", 1);
            return true;
        }
        count = 0;
        boolean isGNF = true;
        int i3 = 0;
        while (i3 < p.length) {
            if (p[i3].getRHS().length() == 0) {
                ++count;
            } else {
                char firstCh = p[i3].getRHS().charAt(0);
                if (ProductionChecker.isTerminal(firstCh)) {
                    int j = 1;
                    while (j < p[i3].getRHS().length()) {
                        if (!ProductionChecker.isVariable(p[i3].getRHS().charAt(j))) {
                            isGNF = false;
                        }
                        ++j;
                    }
                } else {
                    isGNF = false;
                }
            }
            ++i3;
        }
        if (isGNF) {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a GNF Grammar (also Context-Free Grammar)", "Grammar Type", 1);
        } else {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a Context-Free Grammar", "Grammar Type", 1);
        }
        return true;
    }

    private boolean checkforLinearity(Production[] p) {
        int count = 0;
        int i = 0;
        while (i < p.length) {
            if (ProductionChecker.isRightLinear(p[i])) {
                ++count;
            }
            ++i;
        }
        if (count == p.length) {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a right-linear Grammar (Regular Grammar and Context-Free Grammar)", "Grammar Type", 1);
            return true;
        }
        count = 0;
        i = 0;
        while (i < p.length) {
            if (ProductionChecker.isLeftLinear(p[i])) {
                ++count;
            }
            ++i;
        }
        if (count == p.length) {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a left-linear Grammar (Regular Grammar and Context-Free Grammar)", "Grammar Type", 1);
            return true;
        }
        return false;
    }
}

