/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TableTextSizeSlider
extends JSlider {
    private static final long serialVersionUID = 1L;
    static final int FONT_SIZE_MIN = 1;
    static final int FONT_SIZE_MAX = 600;
    static final int FONT_SIZE_INIT = 200;
    static String TABLE_SIZE_TITLE = "Table Text Size";
    JTable myTable;

    public TableTextSizeSlider(JTable table, int orientation) {
        super(orientation, 1, 600, 200);
        this.addChangeListener(new SliderListener());
        TABLE_SIZE_TITLE = orientation == 1 ? "TTS" : "Table Text Size";
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TABLE_SIZE_TITLE));
        this.myTable = table;
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            TableTextSizeSlider.this.myTable.setFont(new Font("Default", 0, source.getValue() / 10));
            TableTextSizeSlider.this.myTable.setRowHeight(source.getValue() / 10 + 10);
        }
    }
}

