/*
 * Decompiled with CFR 0.152.
 */
package gui;

import file.Codec;
import file.ParseException;
import gui.ThrowableCatcher;
import gui.action.NewAction;
import gui.action.OpenAction;
import gui.environment.Profile;
import gui.environment.Universe;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Main {
    private static boolean dontQuit;

    public static boolean getDontQuit() {
        return dontQuit;
    }

    public static void main(String[] args) {
        try {
            String v = System.getProperty("java.specification.version");
            double version = Double.parseDouble(v) + 1.0E-5;
            if (version < 1.5) {
                JOptionPane.showMessageDialog(null, "Java 1.5 or higher required to run JFLAP!\nYou appear to be running Java " + v + ".\n" + "This program will now exit.");
                System.exit(0);
            }
        }
        catch (SecurityException v) {
            // empty catch block
        }
        try {
            if (ThrowableCatcher.class == null) {
                // empty if block
            }
            System.setProperty("sun.awt.exception.handler", "gui.ThrowableCatcher");
        }
        catch (SecurityException e) {
            System.err.println("Warning: could not set the AWT exception handler.");
        }
        try {
            if (System.getProperty("os.name").startsWith("Mac OS") && System.getProperty("java.specification.version").equals("1.3")) {
                System.setProperty("com.apple.hwaccel", "false");
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            System.setProperty("java.util.prefs.syncInterval", "2000000");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        NewAction.showNew();
        if (args.length > 0) {
            args[0].equals("text");
            int i = 0;
            while (i < args.length) {
                Codec[] codecs = Universe.CODEC_REGISTRY.getDecoders().toArray(new Codec[0]);
                try {
                    OpenAction.openFile(new File(args[i]), codecs);
                }
                catch (ParseException e) {
                    System.err.println("Could not open " + args[i] + ": " + e.getMessage());
                }
                ++i;
            }
        }
        Main.loadPreferences();
    }

    private static void loadPreferences() {
        Profile current = Universe.curProfile;
        String path = "";
        try {
            path = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        current.pathToFile = path = String.valueOf(path) + "/jflapPreferences.xml";
        if (new File(path).exists()) {
            File file = new File(path);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                try {
                    Document doc = builder.parse(file);
                    Node parent = doc.getDocumentElement().getElementsByTagName(current.EMPTY_STRING_NAME).item(0);
                    if (parent != null) {
                        String empty = parent.getTextContent();
                        if (empty.equals(current.lambdaText)) {
                            current.setEmptyString(current.lambda);
                        } else if (empty.equals(current.epsilonText)) {
                            current.setEmptyString(current.epsilon);
                        }
                    }
                    if ((parent = doc.getDocumentElement().getElementsByTagName("turing_final").item(0)) != null) {
                        String turingFinal = parent.getTextContent();
                        if (turingFinal.equals("true")) {
                            current.setTransitionsFromTuringFinalStateAllowed(true);
                        } else {
                            current.setTransitionsFromTuringFinalStateAllowed(false);
                        }
                    }
                    if ((parent = doc.getDocumentElement().getElementsByTagName("turing_accept_by_final_state").item(0)) != null) {
                        String acceptFinal = parent.getTextContent();
                        if (acceptFinal.equals("true")) {
                            current.setAcceptByFinalState(true);
                        } else {
                            current.setAcceptByFinalState(false);
                        }
                    }
                    if ((parent = doc.getDocumentElement().getElementsByTagName("turing_accept_by_halt").item(0)) != null) {
                        String acceptHalt = parent.getTextContent();
                        if (acceptHalt.equals("true")) {
                            current.setAcceptByHalting(true);
                        } else {
                            current.setAcceptByHalting(false);
                        }
                    }
                    if ((parent = doc.getDocumentElement().getElementsByTagName("turing_allow_stay_on_transition").item(0)) != null) {
                        String allowStay = parent.getTextContent();
                        if (allowStay.equals("true")) {
                            current.setAllowStay(true);
                        } else {
                            current.setAllowStay(false);
                        }
                    }
                    if ((parent = doc.getDocumentElement().getElementsByTagName("undo_amount").item(0)) != null) {
                        String number = parent.getTextContent();
                        current.setNumUndo(Integer.parseInt(number));
                    }
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
    }
}

