/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Production;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;

public class ParseNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private String derivation;
    private Production[] productions;
    private int[] subs;

    public ParseNode(String derivation, Production[] productions, int[] substitutions) {
        this.derivation = derivation;
        if (productions.length != substitutions.length) {
            throw new IllegalArgumentException("Production and substitution array sizes mismatch!");
        }
        this.productions = productions;
        this.subs = substitutions;
    }

    public ParseNode(ParseNode node) {
        this(node.derivation, node.productions, node.subs);
    }

    public String getDerivation() {
        return this.derivation;
    }

    public Production[] getProductions() {
        return this.productions;
    }

    public int[] getSubstitutions() {
        return this.subs;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.derivation);
        sb.append(", ");
        sb.append(Arrays.asList(this.productions) + ", ");
        sb.append('[');
        int j = 0;
        while (j < this.subs.length) {
            if (j != 0) {
                sb.append(", ");
            }
            sb.append(this.subs[j]);
            ++j;
        }
        sb.append(']');
        return sb.toString();
    }
}

