/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.OrderCorrectly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class CYKParser {
    private Production[] myProductions;
    private static String START_VARIABLE;
    private int myTargetLength;
    private ArrayList<Production> myAnswerProductions;
    private HashMap<String, HashSet<String>> myMap;
    private String myTarget;
    private OrderCorrectly myOrderComparator;

    public CYKParser(Grammar grammar) {
        this.myProductions = grammar.getProductions();
        START_VARIABLE = grammar.getStartVariable();
    }

    public boolean solve(String target) {
        int targetLength;
        this.myMap = new HashMap();
        this.myTargetLength = targetLength = target.length();
        this.myTarget = target;
        if (target.equals("")) {
            return false;
        }
        int i = 0;
        while (i < targetLength) {
            String a = target.substring(i, i + 1);
            HashSet<String> temp = new HashSet<String>();
            int count = 0;
            int j = 0;
            while (j < this.myProductions.length) {
                if (this.myProductions[j].getRHS().equals(a)) {
                    ++count;
                    temp.add(this.myProductions[j].getLHS());
                }
                ++j;
            }
            String key = String.valueOf(i) + "," + i;
            this.myMap.put(key, temp);
            if (count == 0) {
                return false;
            }
            count = 0;
            ++i;
        }
        int increment = 1;
        int i2 = 0;
        while (i2 < targetLength) {
            int j = 0;
            while (j < targetLength) {
                if (targetLength <= j + increment) break;
                int k = j + increment;
                this.checkProductions(j, k);
                ++j;
            }
            ++increment;
            ++i2;
        }
        if (increment == 2) {
            return this.myMap.get("0," + (targetLength - 1)).contains(START_VARIABLE);
        }
        return this.myMap.get("0," + (targetLength - 1)).contains(START_VARIABLE);
    }

    private void checkProductions(int x, int y) {
        HashSet<String> tempSet = new HashSet<String>();
        int i = 0;
        while (i < this.myProductions.length) {
            int k = x;
            while (k < y) {
                String key1 = String.valueOf(x) + "," + k;
                String key2 = String.valueOf(k + 1) + "," + y;
                for (String A : this.myMap.get(key1)) {
                    for (String B : this.myMap.get(key2)) {
                        String target = String.valueOf(A) + B;
                        if (!this.myProductions[i].getRHS().equals(target)) continue;
                        HashSet<String> temp2Set = new HashSet<String>();
                        tempSet.add(this.myProductions[i].getLHS());
                        temp2Set.add("0" + A + "/" + key1);
                        temp2Set.add("1" + B + "/" + key2);
                        String tempKey = String.valueOf(x) + "," + y + this.myProductions[i].getLHS();
                        if (this.myMap.get(tempKey) != null) {
                            temp2Set.addAll((Collection)this.myMap.get(tempKey));
                        }
                        this.myMap.put(tempKey, temp2Set);
                    }
                }
                ++k;
            }
            ++i;
        }
        String key = String.valueOf(x) + "," + y;
        this.myMap.put(key, tempSet);
    }

    public ArrayList<Production> getTrace() {
        this.myAnswerProductions = new ArrayList();
        this.myOrderComparator = new OrderCorrectly();
        this.getMoreProductions(START_VARIABLE, "0," + (this.myTargetLength - 1));
        return this.myAnswerProductions;
    }

    private void getMoreProductions(String variable, String location) {
        if (this.myMap.get(String.valueOf(location) + variable) == null) {
            int loc = Integer.parseInt(location.substring(0, location.indexOf(",")));
            this.myAnswerProductions.add(new Production(variable, this.myTarget.substring(loc, loc + 1)));
            return;
        }
        ArrayList<String> optionsA = new ArrayList<String>();
        ArrayList<String> optionsB = new ArrayList<String>();
        String[] A = new String[2];
        String[] B = new String[2];
        for (String var : this.myMap.get(String.valueOf(location) + variable)) {
            if (var.startsWith("0")) {
                optionsA.add(var);
                continue;
            }
            optionsB.add(var);
        }
        Collections.sort(optionsA, this.myOrderComparator);
        Collections.sort(optionsB, this.myOrderComparator);
        boolean isDone = false;
        int i = 0;
        while (i < optionsA.size()) {
            int index = ((String)optionsA.get(i)).indexOf("/");
            String a = ((String)optionsA.get(i)).substring(1, index);
            String locA = ((String)optionsA.get(i)).substring(index + 1);
            int j = 0;
            while (j < optionsB.size()) {
                index = ((String)optionsB.get(i)).indexOf("/");
                String b = ((String)optionsB.get(i)).substring(1, index);
                String locB = ((String)optionsB.get(i)).substring(index + 1);
                Production p = new Production(variable, String.valueOf(a) + b);
                int k = 0;
                while (k < this.myProductions.length) {
                    if (this.myProductions[k].getLHS().equals(p.getLHS()) && this.myProductions[k].getRHS().equals(p.getRHS())) {
                        A[0] = a;
                        A[1] = locA;
                        B[0] = b;
                        B[1] = locB;
                        isDone = true;
                        break;
                    }
                    ++k;
                }
                if (isDone) break;
                ++j;
            }
            if (isDone) break;
            ++i;
        }
        this.myAnswerProductions.add(new Production(variable, String.valueOf(A[0]) + B[0]));
        this.getMoreProductions(A[0], A[1]);
        this.getMoreProductions(B[0], B[1]);
    }
}

