/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import automata.State;
import automata.Transition;
import automata.UnreachableStatesDetector;
import automata.vdg.VDGTransition;
import automata.vdg.VariableDependencyGraph;
import grammar.Grammar;
import grammar.GrammarChecker;
import grammar.Production;
import grammar.ProductionChecker;
import grammar.cfg.ContextFreeGrammar;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class UselessProductionRemover {
    protected static String START_SYMBOL = "S";

    public static Set<String> getCompleteUsefulVariableSet(Grammar grammar) {
        Set<String> set = UselessProductionRemover.getNewUsefulVariableSet();
        while (UselessProductionRemover.areMoreVariablesThatBelongInUsefulVariableSet(grammar, set)) {
            String variable = UselessProductionRemover.getVariableThatBelongsInUsefulVariableSet(grammar, set);
            UselessProductionRemover.addToUsefulVariableSet(variable, set);
        }
        return set;
    }

    private static Set<String> getNewUsefulVariableSet() {
        return new HashSet<String>();
    }

    public static void addToUsefulVariableSet(String variable, Set<String> set) {
        set.add(variable);
    }

    public static Set<String> getTerminalProductions(Grammar grammar) {
        TreeSet<String> terminalDerivers = new TreeSet<String>();
        Production[] p = grammar.getProductions();
        int i = 0;
        while (i < p.length) {
            String lhs = p[i].getLHS();
            if (!terminalDerivers.contains(lhs)) {
                String rhs = p[i].getRHS();
                int k = 0;
                while (k < rhs.length()) {
                    char ch = rhs.charAt(k);
                    if (ProductionChecker.isVariable(ch)) {
                        lhs = null;
                        break;
                    }
                    ++k;
                }
                if (lhs != null) {
                    terminalDerivers.add(lhs);
                }
            }
            ++i;
        }
        return terminalDerivers;
    }

    public static Grammar getTerminalGrammar(Grammar grammar) {
        ContextFreeGrammar g = new ContextFreeGrammar();
        Set<String> terminalVars = UselessProductionRemover.getCompleteUsefulVariableSet(grammar);
        Production[] prods = grammar.getProductions();
        int i = 0;
        while (i < prods.length) {
            HashSet<String> v = new HashSet<String>(Arrays.asList(prods[i].getVariables()));
            v.removeAll(terminalVars);
            if (v.size() <= 0) {
                g.addProduction(prods[i]);
            }
            ++i;
        }
        g.setStartVariable(grammar.getStartVariable());
        return g;
    }

    public static String getVariableThatBelongsInUsefulVariableSet(Grammar grammar, Set<String> set) {
        String[] variables = grammar.getVariables();
        int k = 0;
        while (k < variables.length) {
            if (UselessProductionRemover.belongsInUsefulVariableSet(variables[k], grammar, set) && !set.contains(variables[k])) {
                return variables[k];
            }
            ++k;
        }
        return null;
    }

    private static boolean isInUsefulVariableSet(char ch, Set<String> set) {
        for (String variable : set) {
            char var = variable.charAt(0);
            if (ch != var) continue;
            return true;
        }
        return false;
    }

    private static boolean isUsefulProduction(Production production, Set<String> set) {
        ProductionChecker pc = new ProductionChecker();
        String rhs = production.getRHS();
        int k = 0;
        while (k < rhs.length()) {
            char ch = rhs.charAt(k);
            if (!ProductionChecker.isTerminal(ch) && !UselessProductionRemover.isInUsefulVariableSet(ch, set)) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public static boolean isValidProduction(Production production, Set<String> set) {
        String lhs = production.getLHS();
        int k = 0;
        while (k < lhs.length()) {
            if (!UselessProductionRemover.isInUsefulVariableSet(lhs.charAt(k), set)) {
                return false;
            }
            ++k;
        }
        return UselessProductionRemover.isUsefulProduction(production, set);
    }

    public static boolean belongsInUsefulVariableSet(String variable, Grammar grammar, Set<String> set) {
        GrammarChecker gc = new GrammarChecker();
        Production[] productions = GrammarChecker.getProductionsOnVariable(variable, grammar);
        int k = 0;
        while (k < productions.length) {
            if (UselessProductionRemover.isUsefulProduction(productions[k], set)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static boolean areMoreVariablesThatBelongInUsefulVariableSet(Grammar grammar, Set<String> set) {
        return UselessProductionRemover.getVariableThatBelongsInUsefulVariableSet(grammar, set) != null;
    }

    public static Set<Production> getCompleteProductionWithUsefulVariableSet(Grammar grammar, Set<String> usefulVariableSet) {
        Set<Production> set = UselessProductionRemover.getNewProductionWithUsefulVariableSet();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (UselessProductionRemover.belongsInProductionWithUsefulVariableSet(productions[k], usefulVariableSet)) {
                set.add(productions[k]);
            }
            ++k;
        }
        return set;
    }

    public static Set<Production> getNewProductionWithUsefulVariableSet() {
        return new HashSet<Production>();
    }

    public static boolean belongsInProductionWithUsefulVariableSet(Production production, Set<String> usefulVariableSet) {
        return UselessProductionRemover.isValidProduction(production, usefulVariableSet);
    }

    public static void addToProductionWithUsefulVariableSet(Production production, Set<Production> set) {
        set.add(production);
    }

    public static void initializeVariableDependencyGraph(VariableDependencyGraph graph, Grammar grammar) {
        String[] variables = UselessProductionRemover.getCompleteUsefulVariableSet(grammar).toArray(new String[0]);
        int k = 0;
        while (k < variables.length) {
            double theta = Math.PI * 2 * (double)k / (double)variables.length;
            Point point = new Point(200 + (int)(180.0 * Math.cos(theta)), 200 + (int)(180.0 * Math.sin(theta)));
            State state = graph.createState(point);
            state.setName(variables[k]);
            if (variables[k].equals(grammar.getStartVariable())) {
                graph.setInitialState(state);
            }
            ++k;
        }
    }

    public static boolean isDependentOn(String v1, String v2, Grammar grammar) {
        GrammarChecker gc = new GrammarChecker();
        ProductionChecker pc = new ProductionChecker();
        Production[] productions = GrammarChecker.getProductionsOnVariable(v1, grammar);
        int k = 0;
        while (k < productions.length) {
            if (ProductionChecker.isVariableInProduction(v2, productions[k])) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static Transition getTransition(String v1, String v2, VariableDependencyGraph graph) {
        State from = UselessProductionRemover.getStateForVariable(v1, graph);
        State to = UselessProductionRemover.getStateForVariable(v2, graph);
        return new VDGTransition(from, to);
    }

    public static State getStateForVariable(String variable, VariableDependencyGraph graph) {
        State[] states = graph.getStates();
        int k = 0;
        while (k < states.length) {
            State state = states[k];
            if (state.getName().equals(variable)) {
                return state;
            }
            ++k;
        }
        return null;
    }

    public static VariableDependencyGraph getVariableDependencyGraph(Grammar grammar) {
        VariableDependencyGraph graph = new VariableDependencyGraph();
        UselessProductionRemover.initializeVariableDependencyGraph(graph, grammar);
        String[] variables = UselessProductionRemover.getCompleteUsefulVariableSet(grammar).toArray(new String[0]);
        int k = 0;
        while (k < variables.length) {
            String v1 = variables[k];
            int i = 0;
            while (i < variables.length) {
                String v2 = variables[i];
                if (i != k && UselessProductionRemover.isDependentOn(v1, v2, grammar)) {
                    Transition trans = UselessProductionRemover.getTransition(v1, v2, graph);
                    graph.addTransition(trans);
                }
                ++i;
            }
            ++k;
        }
        return graph;
    }

    public static Transition[] getTransitionsForProduction(Production production, VariableDependencyGraph graph) {
        ArrayList<Transition> list = new ArrayList<Transition>();
        String v1 = production.getLHS();
        ProductionChecker pc = new ProductionChecker();
        String rhs = production.getRHS();
        int k = 0;
        while (k < rhs.length()) {
            char ch = rhs.charAt(k);
            if (ProductionChecker.isVariable(ch)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(ch);
                list.add(UselessProductionRemover.getTransition(v1, buffer.toString(), graph));
            }
            ++k;
        }
        return list.toArray(new Transition[0]);
    }

    public static String[] getUselessVariables(Grammar grammar, VariableDependencyGraph graph) {
        ArrayList<String> list = new ArrayList<String>();
        UnreachableStatesDetector usd = new UnreachableStatesDetector(graph);
        State[] states = usd.getUnreachableStates();
        int k = 0;
        while (k < states.length) {
            list.add(states[k].getName());
            ++k;
        }
        return list.toArray(new String[0]);
    }

    public static void removeProductionsForVariable(String variable, Grammar grammar) {
        GrammarChecker gc = new GrammarChecker();
        Production[] productions = GrammarChecker.getProductionsWithVariable(variable, grammar);
        int k = 0;
        while (k < productions.length) {
            grammar.removeProduction(productions[k]);
            ++k;
        }
    }

    private static Grammar getGrammarWithNoVariablesThatCantDeriveStrings(Set<Production> usefulProductionSet) {
        ContextFreeGrammar g = new ContextFreeGrammar();
        for (Production p : usefulProductionSet) {
            g.addProduction(p);
        }
        return g;
    }

    public static Grammar getUselessProductionlessGrammar(Grammar grammar) {
        ContextFreeGrammar g = new ContextFreeGrammar();
        g.setStartVariable(grammar.getStartVariable());
        if (!UselessProductionRemover.getCompleteUsefulVariableSet(grammar).contains(grammar.getStartVariable())) {
            return g;
        }
        grammar = UselessProductionRemover.getTerminalGrammar(grammar);
        VariableDependencyGraph graph = UselessProductionRemover.getVariableDependencyGraph(grammar);
        HashSet<String> useless = new HashSet<String>(Arrays.asList(UselessProductionRemover.getUselessVariables(g, graph)));
        Production[] p = grammar.getProductions();
        int i = 0;
        while (i < p.length) {
            HashSet<String> variables = new HashSet<String>(Arrays.asList(p[i].getVariables()));
            variables.retainAll(useless);
            if (variables.size() <= 0) {
                g.addProduction(p[i]);
            }
            ++i;
        }
        return g;
    }
}

