/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import file.xml.PumpingLemmaFactory;
import file.xml.PumpingLemmaTransducer;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import pumping.RegularPumpingLemma;

public class RegPumpingLemmaTransducer
extends PumpingLemmaTransducer {
    public static String TYPE = "regular pumping lemma";
    public static String X_NAME = "xLength";
    public static String Y_NAME = "yLength";

    @Override
    public Serializable fromDOM(Document document) {
        RegularPumpingLemma pl = (RegularPumpingLemma)PumpingLemmaFactory.createPumpingLemma(TYPE, document.getElementsByTagName(LEMMA_NAME).item(0).getTextContent());
        pl.setM(Integer.parseInt(document.getElementsByTagName(M_NAME).item(0).getTextContent()));
        pl.setW(document.getElementsByTagName(W_NAME).item(0).getTextContent());
        pl.setI(Integer.parseInt(document.getElementsByTagName(I_NAME).item(0).getTextContent()));
        NodeList attempts = document.getDocumentElement().getElementsByTagName(ATTEMPT);
        int i = 0;
        while (i < attempts.getLength()) {
            pl.addAttempt(attempts.item(i).getTextContent());
            ++i;
        }
        pl.setFirstPlayer(document.getElementsByTagName(FIRST_PLAYER).item(0).getTextContent());
        int xLength = Integer.parseInt(document.getElementsByTagName(X_NAME).item(0).getTextContent());
        int yLength = Integer.parseInt(document.getElementsByTagName(Y_NAME).item(0).getTextContent());
        pl.setDecomposition(new int[]{xLength, yLength});
        return pl;
    }

    @Override
    public Document toDOM(Serializable structure) {
        RegularPumpingLemma pl = (RegularPumpingLemma)structure;
        Document doc = this.newEmptyDocument();
        Element elem = doc.getDocumentElement();
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, LEMMA_NAME, null, pl.getTitle()));
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, FIRST_PLAYER, null, pl.getFirstPlayer()));
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, M_NAME, null, "" + pl.getM()));
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, W_NAME, null, pl.getW()));
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, I_NAME, null, "" + pl.getI()));
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, X_NAME, null, "" + pl.getX().length()));
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, Y_NAME, null, "" + pl.getY().length()));
        ArrayList<String> attempts = pl.getAttempts();
        if (attempts != null && attempts.size() > 0) {
            int i = 0;
            while (i < attempts.size()) {
                elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, ATTEMPT, null, attempts.get(i)));
                ++i;
            }
        }
        return doc;
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

