/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.pda.PDATransition;
import automata.pda.PushdownAutomaton;
import file.DataException;
import file.xml.AutomatonTransducer;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PDATransducer
extends AutomatonTransducer {
    public static final String TRANSITION_READ_NAME = "read";
    public static final String TRANSITION_POP_NAME = "pop";
    public static final String TRANSITION_PUSH_NAME = "push";

    @Override
    protected Automaton createEmptyAutomaton(Document document) {
        return new PushdownAutomaton();
    }

    @Override
    protected Transition createTransition(State from, State to, Node node, Map<String, String> e2t, boolean bool) {
        String read = e2t.get(TRANSITION_READ_NAME);
        String pop = e2t.get(TRANSITION_POP_NAME);
        String push = e2t.get(TRANSITION_PUSH_NAME);
        if (read == null) {
            read = "";
        }
        if (pop == null) {
            pop = "";
        }
        if (push == null) {
            push = "";
        }
        try {
            return new PDATransition(from, to, read, pop, push);
        }
        catch (IllegalArgumentException e) {
            throw new DataException(e.getMessage());
        }
    }

    @Override
    protected Element createTransitionElement(Document document, Transition transition) {
        Element te = super.createTransitionElement(document, transition);
        PDATransition t = (PDATransition)transition;
        te.appendChild(PDATransducer.createElement(document, TRANSITION_READ_NAME, null, t.getInputToRead()));
        te.appendChild(PDATransducer.createElement(document, TRANSITION_POP_NAME, null, t.getStringToPop()));
        te.appendChild(PDATransducer.createElement(document, TRANSITION_PUSH_NAME, null, t.getStringToPush()));
        return te;
    }

    @Override
    public String getType() {
        return "pda";
    }
}

