/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import java.util.ArrayList;

public class VertexChain {
    ArrayList<Object> vertices = new ArrayList();
    Graph graph;

    public VertexChain(Graph g) {
        this.graph = g;
    }

    public Object get(int index) {
        return this.vertices.get(index);
    }

    public ArrayList<Object> getVertices() {
        return this.vertices;
    }

    public int size() {
        return this.vertices.size();
    }

    public boolean isEdgeToChainMember(Object vertex) {
        return this.getDegreeInChain(vertex) > 0;
    }

    public int getDegreeInChain(Object vertex) {
        int count = 0;
        int i = 0;
        while (i < this.vertices.size()) {
            if (this.graph.hasEdge(vertex, this.vertices.get(i)) && !this.vertices.get(i).equals(vertex)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void orientSubChain(int destIndex, int matchingIndex, int start, int end, boolean shuffleDirection) {
        Object[] toMove = new Object[end - start + 1];
        int chainSize = this.size();
        int dest = destIndex > 0 && destIndex >= start ? destIndex + start - end - 1 : destIndex;
        int i = start;
        while (i <= end) {
            toMove[i - start] = this.get(i);
            ++i;
        }
        i = 0;
        while (i < toMove.length) {
            this.vertices.remove(toMove[i]);
            ++i;
        }
        i = 0;
        while (i < toMove.length) {
            if (shuffleDirection) {
                if (destIndex == chainSize || dest == this.size()) {
                    if (matchingIndex == start) {
                        this.vertices.add(toMove[toMove.length - 1 - i]);
                    } else {
                        this.vertices.add(toMove[i]);
                    }
                } else if (matchingIndex == start) {
                    this.vertices.add(dest + 1, toMove[toMove.length - 1 - i]);
                } else {
                    this.vertices.add(dest + 1, toMove[i]);
                }
            } else if (matchingIndex == start) {
                this.vertices.add(dest, toMove[i]);
            } else {
                this.vertices.add(dest, toMove[toMove.length - 1 - i]);
            }
            ++i;
        }
    }

    public void addVertex(Object vertex) {
        int i = 0;
        while (i < this.size()) {
            if (this.graph.hasEdge(vertex, this.get(i))) {
                int destIndex = i == this.size() - 1 || !this.graph.hasEdge(this.get(i), this.get(i + 1)) ? i + 1 : i;
                this.vertices.add(destIndex, vertex);
                int j = i + 2;
                while (j < this.size()) {
                    if (this.graph.hasEdge(vertex, this.get(j)) && this.getDegreeInChain(this.get(j)) <= 2) {
                        if (j < this.size() - 1 && this.graph.hasEdge(this.get(j), this.get(j + 1))) {
                            this.orientSubChain(destIndex, j, j, this.size() - 1, destIndex == i + 1);
                        } else {
                            int subChainBound = j;
                            while (subChainBound > i + 2 && this.graph.hasEdge(this.get(subChainBound - 1), this.get(subChainBound))) {
                                --subChainBound;
                            }
                            this.orientSubChain(destIndex, j, subChainBound, j, destIndex == i + 1);
                        }
                        return;
                    }
                    ++j;
                }
                return;
            }
            ++i;
        }
        this.vertices.add(vertex);
    }

    public static void alignTwoChains(VertexChain first, VertexChain next, Graph graph) {
        int j = 0;
        while (j < first.size()) {
            int k = 0;
            while (k < next.size()) {
                if (first.getDegreeInChain(first.get(j)) < 2 && next.getDegreeInChain(next.get(k)) < 2 && graph.hasEdge(first.get(j), next.get(k))) {
                    int fstart = j;
                    int fend = j;
                    int nstart = k;
                    int nend = k;
                    while (fstart > 0 && graph.hasEdge(first.get(fstart), first.get(fstart - 1))) {
                        --fstart;
                    }
                    while (fend < first.size() - 1 && graph.hasEdge(first.get(fend), first.get(fend + 1))) {
                        ++fend;
                    }
                    while (nstart > 0 && graph.hasEdge(next.get(nstart), next.get(nstart - 1))) {
                        --nstart;
                    }
                    while (nend < next.size() - 1 && graph.hasEdge(next.get(nend), next.get(nend + 1))) {
                        ++nend;
                    }
                    first.orientSubChain(first.size() - 1, fstart + fend - j, fstart, fend, true);
                    next.orientSubChain(0, nstart + nend - k, nstart, nend, false);
                    return;
                }
                ++k;
            }
            ++j;
        }
    }
}

