/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.CircleChain;
import automata.graph.layout.RandomLayoutAlgorithm;
import automata.graph.layout.VertexChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TwoCircleLayoutAlgorithm
extends LayoutAlgorithm {
    public Graph graph;
    ArrayList<Object> vertices;
    ArrayList<Object> innerCircle;
    ArrayList<Object> outerCircle;
    CircleChain[] outerCircleChains;
    CircleChain innerCircleChain;

    public TwoCircleLayoutAlgorithm() {
    }

    public TwoCircleLayoutAlgorithm(Dimension pSize, Dimension vDim, double vBuffer) {
        super(pSize, vDim, vBuffer);
    }

    @Override
    public void layout(Graph g, Set<Object> notMoving) {
        this.graph = g;
        this.innerCircle = new ArrayList();
        this.outerCircle = new ArrayList();
        this.vertices = TwoCircleLayoutAlgorithm.getMovableVertices(this.graph, notMoving);
        if (this.graph == null || this.vertices.size() == 0) {
            return;
        }
        this.assignToCircles();
        this.innerCircleChain = new CircleChain(this.graph, this.vertexDim, this.vertexBuffer);
        int i = 0;
        while (i < this.innerCircle.size()) {
            this.innerCircleChain.addVertex(this.innerCircle.get(i));
            ++i;
        }
        this.innerCircleChain.layout(0.0, Math.PI, Math.PI * 2);
        this.innerCircle = this.innerCircleChain.getVertices();
        if (this.outerCircle.size() > 0) {
            this.createOuterCircleChains();
            this.shuffleOuterChains();
            double radius = this.innerCircleChain.getRadius();
            double division = Math.PI * 2 / (double)this.outerCircleChains.length;
            double span = division * 4.0 / 5.0;
            int i2 = 0;
            while (i2 < this.outerCircleChains.length) {
                this.outerCircleChains[i2].layout(radius, division * (double)i2, span);
                ++i2;
            }
        }
        TwoCircleLayoutAlgorithm.polarToCartesian(this.graph, this.vertices);
        TwoCircleLayoutAlgorithm.shiftOntoScreen(this.graph, this.size, this.vertexDim, true);
    }

    protected void assignToCircles() {
        boolean innerCircleInsertion;
        int i = 0;
        while (i < this.vertices.size()) {
            if (this.graph.degree(this.vertices.get(i)) > 2) {
                this.innerCircle.add(this.vertices.get(i));
            } else {
                this.outerCircle.add(this.vertices.get(i));
            }
            ++i;
        }
        if (this.innerCircle.size() == 0) {
            this.innerCircle = this.outerCircle;
            this.outerCircle = new ArrayList();
            return;
        }
        do {
            innerCircleInsertion = false;
            int i2 = 0;
            while (i2 < this.outerCircle.size()) {
                int count = 0;
                int j = 0;
                while (j < this.innerCircle.size()) {
                    if (this.graph.hasEdge(this.outerCircle.get(i2), this.innerCircle.get(j))) {
                        ++count;
                    }
                    ++j;
                }
                if (count >= 2) {
                    this.innerCircle.add(this.outerCircle.get(i2));
                    this.outerCircle.remove(i2);
                    innerCircleInsertion = true;
                }
                ++i2;
            }
        } while (innerCircleInsertion);
    }

    protected void createOuterCircleChains() {
        int min;
        int i;
        this.outerCircleChains = new CircleChain[this.innerCircle.size()];
        int[] chainIndex = new int[this.outerCircle.size()];
        int i2 = 0;
        while (i2 < this.outerCircleChains.length) {
            this.outerCircleChains[i2] = new CircleChain(this.graph, this.vertexDim, this.vertexBuffer);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.outerCircle.size()) {
            chainIndex[i2] = -1;
            int j = 0;
            while (j < this.innerCircle.size()) {
                if (this.graph.hasEdge(this.outerCircle.get(i2), this.innerCircle.get(j))) {
                    this.outerCircleChains[j].addVertex(this.outerCircle.get(i2));
                    chainIndex[i2] = j;
                }
                ++j;
            }
            ++i2;
        }
        boolean addedToChain = false;
        do {
            addedToChain = false;
            i = 0;
            while (i < this.outerCircle.size()) {
                if (chainIndex[i] == -1) {
                    int match1 = -1;
                    int match2 = -1;
                    int j = 0;
                    while (j < this.outerCircleChains.length) {
                        if (this.outerCircleChains[j].isEdgeToChainMember(this.outerCircle.get(i)) && chainIndex[i] == -1) {
                            if (match1 == -1) {
                                match1 = j;
                            } else {
                                match2 = j;
                            }
                        }
                        ++j;
                    }
                    if (match1 > -1 && match2 == -1) {
                        this.outerCircleChains[match1].addVertex(this.outerCircle.get(i));
                        chainIndex[i] = match1;
                        addedToChain = true;
                    } else if (match1 > -1 && match2 > -1) {
                        min = this.outerCircleChains[match1].size() < this.outerCircleChains[match2].size() ? match1 : match2;
                        this.outerCircleChains[min].addVertex(this.outerCircle.get(i));
                        chainIndex[i] = min;
                        addedToChain = true;
                    }
                }
                ++i;
            }
        } while (addedToChain);
        min = 0;
        i = 0;
        while (i < this.outerCircleChains.length) {
            if (this.outerCircleChains[min].getVertices().size() > this.outerCircleChains[i].getVertices().size()) {
                min = i;
            }
            ++i;
        }
        i = 0;
        while (i < this.outerCircle.size()) {
            if (chainIndex[i] == -1) {
                this.outerCircleChains[min].addVertex(this.outerCircle.get(i));
            }
            ++i;
        }
    }

    protected void shuffleOuterChains() {
        int i = 0;
        while (i < this.outerCircleChains.length) {
            CircleChain currentChain = this.outerCircleChains[i];
            CircleChain nextChain = i < this.outerCircleChains.length - 1 ? this.outerCircleChains[i + 1] : this.outerCircleChains[0];
            VertexChain.alignTwoChains(currentChain, nextChain, this.graph);
            ++i;
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        f.setSize(900, 900);
        f.setContentPane(p);
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        String[] vertices = new String[20];
        Graph graph = new Graph();
        RandomLayoutAlgorithm layout = new RandomLayoutAlgorithm();
        int i = 0;
        while (i < vertices.length) {
            vertices[i] = "V" + i;
            graph.addVertex(vertices[i], new Point2D.Double(0.0, 0.0));
            if (i > 0) {
                graph.addEdge(vertices[i], vertices[i - 1]);
            }
            ++i;
        }
        HashSet<Object> set = new HashSet<Object>();
        ((LayoutAlgorithm)layout).layout(graph, set);
        int i2 = 0;
        while (i2 < vertices.length) {
            Point2D p2d = graph.pointForVertex(vertices[i2]);
            p.getGraphics().drawString(vertices[i2], (int)p2d.getX(), (int)p2d.getY() - 10);
            p.getGraphics().fillRect((int)p2d.getX(), (int)p2d.getY(), 30, 30);
            ++i2;
        }
        i2 = 0;
        while (i2 < vertices.length) {
            int j = 0;
            while (j < vertices.length) {
                if (graph.hasEdge(vertices[i2], vertices[j])) {
                    p.getGraphics().drawLine((int)graph.pointForVertex(vertices[i2]).getX(), (int)graph.pointForVertex(vertices[i2]).getY(), (int)graph.pointForVertex(vertices[j]).getX(), (int)graph.pointForVertex(vertices[j]).getY());
                }
                ++j;
            }
            ++i2;
        }
        p.revalidate();
    }
}

