/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.VertexChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class SpiralLayoutAlgorithm
extends LayoutAlgorithm {
    private Graph graph;

    public SpiralLayoutAlgorithm() {
    }

    public SpiralLayoutAlgorithm(Dimension pSize, Dimension vDim, double vBuffer) {
        super(pSize, vDim, vBuffer);
    }

    @Override
    public void layout(Graph g, Set<Object> notMoving) {
        this.graph = g;
        ArrayList<Object> vertices = SpiralLayoutAlgorithm.getMovableVertices(this.graph, notMoving);
        if (this.graph == null || vertices.size() == 0) {
            return;
        }
        VertexChain chain = new VertexChain(this.graph);
        Collections.sort(vertices, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (SpiralLayoutAlgorithm.this.graph.degree(o1) == SpiralLayoutAlgorithm.this.graph.degree(o2)) {
                    return 0;
                }
                if (SpiralLayoutAlgorithm.this.graph.degree(o1) > SpiralLayoutAlgorithm.this.graph.degree(o2)) {
                    return -1;
                }
                return 1;
            }
        });
        int i = 0;
        while (i < vertices.size()) {
            chain.addVertex(vertices.get(i));
            ++i;
        }
        double r = 0.0;
        double theta = 0.0;
        double posShift = Math.sqrt(Math.pow(this.vertexDim.getHeight(), 2.0) + Math.pow(this.vertexDim.getWidth(), 2.0)) + this.vertexBuffer;
        int i2 = 0;
        while (i2 < vertices.size()) {
            r = Math.sqrt(Math.pow(r, 2.0) + Math.pow(posShift, 2.0));
            this.graph.moveVertex(chain.get(i2), new Point2D.Double(r, theta += Math.asin(posShift / r)));
            ++i2;
        }
        SpiralLayoutAlgorithm.polarToCartesian(this.graph, vertices);
        SpiralLayoutAlgorithm.shiftOntoScreen(this.graph, this.size, this.vertexDim, true);
    }
}

