/*
 * Decompiled with CFR 0.152.
 */
package automata.graph;

import automata.State;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import java.util.HashMap;
import java.util.Map;

public class DFAEqualityChecker {
    private boolean hypothesize(State state1, State state2, Map<State, State> matching) {
        Transition[] t2;
        State counterpart = matching.get(state1);
        if (counterpart != null) {
            return counterpart == state2;
        }
        if (state1.getAutomaton().isFinalState(state1) ^ state2.getAutomaton().isFinalState(state2)) {
            return false;
        }
        HashMap<String, Transition> labelToTrans1 = new HashMap<String, Transition>();
        HashMap<String, Transition> labelToTrans2 = new HashMap<String, Transition>();
        Transition[] t1 = state1.getAutomaton().getTransitionsFromState(state1);
        if (t1.length != (t2 = state2.getAutomaton().getTransitionsFromState(state2)).length) {
            return false;
        }
        int i = 0;
        while (i < t1.length) {
            labelToTrans1.put(((FSATransition)t1[i]).getLabel(), t1[i]);
            labelToTrans2.put(((FSATransition)t2[i]).getLabel(), t2[i]);
            ++i;
        }
        i = 0;
        while (i < t1.length) {
            String label = ((FSATransition)t1[i]).getLabel();
            Transition counterpart2 = (Transition)labelToTrans2.get(label);
            if (counterpart2 == null) {
                return false;
            }
            matching.put(state1, state2);
            boolean equal = this.hypothesize(t1[i].getToState(), counterpart2.getToState(), matching);
            if (!equal) {
                matching.remove(state1);
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(FiniteStateAutomaton one, FiniteStateAutomaton two) {
        if (one.getStates().length != two.getStates().length) {
            return false;
        }
        return this.hypothesize(one.getInitialState(), two.getInitialState(), new HashMap<State, State>());
    }
}

