/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.State;
import automata.Transition;
import automata.fsa.FSAConfiguration;
import automata.fsa.FSATransition;
import debug.EDebug;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class FSAStepByStateSimulator
extends AutomatonSimulator {
    public FSAStepByStateSimulator(Automaton automaton) {
        super(automaton);
    }

    @Override
    public Configuration[] getInitialConfigurations(String input) {
        Configuration[] configs = new Configuration[]{new FSAConfiguration(this.myAutomaton.getInitialState(), null, input, input)};
        return configs;
    }

    @Override
    public ArrayList<Configuration> stepConfiguration(Configuration config) {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        FSAConfiguration configuration = (FSAConfiguration)config;
        String unprocessedInput = configuration.getUnprocessedInput();
        String totalInput = configuration.getInput();
        State currentState = configuration.getCurrentState();
        Transition[] transitions = this.myAutomaton.getTransitionsFromState(currentState);
        int k = 0;
        while (k < transitions.length) {
            FSATransition transition = (FSATransition)transitions[k];
            String transLabel = transition.getLabel();
            HashSet<String> trange = new HashSet<String>();
            if (transLabel.contains("[")) {
                int i = transLabel.charAt(transLabel.indexOf("[") + 1);
                while (i <= transLabel.charAt(transLabel.indexOf("[") + 3)) {
                    trange.add(Character.toString((char)i));
                    EDebug.print(Character.toString((char)i));
                    ++i;
                }
                for (String element : trange) {
                    if (!unprocessedInput.startsWith(element)) continue;
                    String input = "";
                    if (element.length() < unprocessedInput.length()) {
                        input = unprocessedInput.substring(element.length());
                    }
                    State toState = transition.getToState();
                    FSAConfiguration configurationToAdd = new FSAConfiguration(toState, configuration, totalInput, input);
                    list.add(configurationToAdd);
                }
            } else if (unprocessedInput.startsWith(transLabel)) {
                String input = "";
                if (transLabel.length() < unprocessedInput.length()) {
                    input = unprocessedInput.substring(transLabel.length());
                }
                State toState = transition.getToState();
                FSAConfiguration configurationToAdd = new FSAConfiguration(toState, configuration, totalInput, input);
                list.add(configurationToAdd);
            }
            ++k;
        }
        return list;
    }

    @Override
    public boolean isAccepted() {
        for (FSAConfiguration configuration : this.myConfigurations) {
            State currentState = configuration.getCurrentState();
            if (!configuration.getUnprocessedInput().equals("") || !this.myAutomaton.isFinalState(currentState)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean simulateInput(String input) {
        this.myConfigurations.clear();
        Configuration[] initialConfigs = this.getInitialConfigurations(input);
        int k = 0;
        while (k < initialConfigs.length) {
            FSAConfiguration initialConfiguration = (FSAConfiguration)initialConfigs[k];
            this.myConfigurations.add(initialConfiguration);
            ++k;
        }
        while (!this.myConfigurations.isEmpty()) {
            if (this.isAccepted()) {
                return true;
            }
            ArrayList<Configuration> configurationsToAdd = new ArrayList<Configuration>();
            Iterator it = this.myConfigurations.iterator();
            while (it.hasNext()) {
                FSAConfiguration configuration = (FSAConfiguration)it.next();
                ArrayList<Configuration> configsToAdd = this.stepConfiguration(configuration);
                configurationsToAdd.addAll(configsToAdd);
                it.remove();
            }
            this.myConfigurations.addAll(configurationsToAdd);
        }
        return false;
    }
}

