/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.Automaton;
import automata.Node;
import automata.State;
import automata.Transition;
import java.util.ArrayList;

public class UnreachableStatesDetector {
    protected Automaton myAutomaton;
    protected Node[] myNodes;

    public UnreachableStatesDetector(Automaton automaton) {
        this.myAutomaton = automaton;
    }

    public void initializeNodes(State[] states) {
        this.myNodes = new Node[states.length];
        int k = 0;
        while (k < states.length) {
            Node node = new Node(states[k]);
            node.colorWhite();
            this.myNodes[k] = node;
            ++k;
        }
    }

    public State[] getUnreachableStates() {
        ArrayList<State> list = new ArrayList<State>();
        State[] states = this.myAutomaton.getStates();
        this.initializeNodes(states);
        Node initialNode = this.getNodeForState(this.myAutomaton.getInitialState());
        this.visit(initialNode);
        int k = 0;
        while (k < this.myNodes.length) {
            if (this.myNodes[k].isWhite()) {
                list.add(this.myNodes[k].getState());
            }
            ++k;
        }
        return list.toArray(new State[0]);
    }

    public Node getNodeForState(State state) {
        int k = 0;
        while (k < this.myNodes.length) {
            Node node = this.myNodes[k];
            if (node.getState() == state) {
                return node;
            }
            ++k;
        }
        return null;
    }

    public void visit(Node node) {
        node.colorGrey();
        Transition[] transitions = this.myAutomaton.getTransitionsFromState(node.getState());
        int k = 0;
        while (k < transitions.length) {
            Transition transition = transitions[k];
            State toState = transition.getToState();
            Node v = this.getNodeForState(toState);
            if (v.isWhite()) {
                this.visit(v);
            }
            ++k;
        }
        node.colorBlack();
    }
}

